local Framework = nil

if Config.Framework == "qb-core" then
    Framework = exports['qb-core']:GetCoreObject()
elseif Config.Framework == "esx" then
    TriggerEvent('esx:getSharedObject', function(obj) Framework = obj end)
end

Framework.Functions.CreateCallback('teleport:checkPermission', function(source, cb)
    local Player = Framework.Functions.GetPlayer(source)

    if not Config.RequirePermission then
        cb(true)
        return
    end

    local steamID = GetPlayerIdentifier(source, 0)
    for _, allowedSteamID in ipairs(Config.AllowedSteamIDs) do
        if steamID == allowedSteamID then
            cb(true)
            return
        end
    end

    local playerJob = Player.PlayerData.job.name
    for _, job in ipairs(Config.AllowedJobs) do
        if playerJob == job then
            cb(true)
            return
        end
    end

    cb(false)
end)
