Config = {}

-- Select Framework: "qb-core" or "esx"
Config.Framework = "qb-core"

-- Select menu type: "qb-menu" or "default"
Config.MenuType = "qb-menu" -- Change to "default" to use the ESX menu

Config.Locations = {
    {label = "Downtown 🏙️", coords = vector3(-267.15, -957.56, 31.22)},
    {label = "Airport ✈️", coords = vector3(-1034.6, -2733.6, 13.8)},
    {label = "Beach 🏖️", coords = vector3(-1600.0, -1030.0, 13.0)},
    {label = "Police Station 🚔", coords = vector3(425.1, -979.5, 30.7)},
    {label = "Hospital 🏥", coords = vector3(307.6, -1433.2, 29.9)},
    {label = "Vinewood Sign 🎥", coords = vector3(709.7, 1208.3, 325.3)},
    {label = "Mount Chiliad 🗻", coords = vector3(450.1, 5566.0, 805.1)},
    {label = "Military Base 🛡️", coords = vector3(-2345.2, 3268.9, 32.8)},
    {label = "Casino 🎰", coords = vector3(935.7, 42.9, 81.1)},
    {label = "Maze Bank Tower 🏢", coords = vector3(-75.0, -818.9, 326.2)},
    {label = "Sandy Shores 🏜️", coords = vector3(1850.0, 3687.0, 34.2)},
    {label = "Paleto Bay 🌲", coords = vector3(-448.6, 5972.3, 31.7)}
}

Config.RequirePermission = false -- If true, permissions are required
Config.AllowedJobs = {"police", "ambulance"} -- Jobs that have access

-- Steam IDs that have access
Config.AllowedSteamIDs = {
    "steam:110000112345678",
    "steam:110000109876543"
}

-- Messages
Config.Messages = {
    NoPermission = "You do not have access to the teleport menu!",
    TeleportSuccess = "You teleported!"
}
