local Framework = nil
local lastLocation = nil

if Config.Framework == "qb-core" then
    Framework = exports['qb-core']:GetCoreObject()
elseif Config.Framework == "esx" then
    TriggerEvent('esx:getSharedObject', function(obj) Framework = obj end)
end

RegisterCommand("spawn", function()
    CheckPermissions(function(hasPermission)
        if hasPermission then
            OpenTeleportMenu()
        else
            Notify(Config.Messages.NoPermission, "error")
        end
    end)
end)

function OpenTeleportMenu()
    local menuItems = {}

    if lastLocation then
        table.insert(menuItems, {
            label = "Last Location 📍",
            description = "Return to your last location.",
            coords = lastLocation
        })
    end

    for _, location in ipairs(Config.Locations) do
        table.insert(menuItems, {
            label = location.label,
            description = "Teleport to location: " .. location.label,
            coords = location.coords
        })
    end

    if Config.MenuType == "qb-menu" then
        local qbMenuItems = {}

        for _, item in ipairs(menuItems) do
            table.insert(qbMenuItems, {
                header = item.label,
                txt = item.description,
                params = {
                    event = "teleport:teleport",
                    args = { coords = item.coords }
                }
            })
        end

        table.insert(qbMenuItems, {
            header = "Close",
            txt = "Close the menu.",
            params = { event = "" }
        })

        exports['qb-menu']:openMenu(qbMenuItems)
    elseif Config.MenuType == "default" then
        local esxMenuItems = {}

        for _, item in ipairs(menuItems) do
            table.insert(esxMenuItems, {
                label = item.label,
                description = item.description,
                coords = item.coords
            })
        end

        ESX.UI.Menu.Open('default', GetCurrentResourceName(), 'teleport_menu', {
            title = "Teleport Menu",
            align = "top-left",
            elements = esxMenuItems
        }, function(data, menu)
            local coords = data.current.coords
            if coords then
                TriggerEvent("teleport:teleport", { coords = coords })
            end
        end, function(data, menu)
            menu.close()
        end)
    end
end

RegisterNetEvent("teleport:teleport", function(data)
    local ped = PlayerPedId()
    lastLocation = GetEntityCoords(ped)
    SetEntityCoords(ped, data.coords.x, data.coords.y, data.coords.z)
    Notify(Config.Messages.TeleportSuccess, "success")
end)

function CheckPermissions(callback)
    if not Config.RequirePermission then
        callback(true)
        return
    end

    Framework.Functions.TriggerCallback('teleport:checkPermission', function(hasPermission)
        callback(hasPermission)
    end)
end

function Notify(message, type)
    if Config.Framework == "qb-core" then
        Framework.Functions.Notify(message, type)
    elseif Config.Framework == "esx" then
        ESX.ShowNotification(message)
    end
end