﻿$(document).ready(() => {
    window.addEventListener("message", event => {
        const data = event.data;

        if (data.hunger !== undefined) {
            updateBar("#hunger .bg", data.hunger);
        }

        if (data.thirst !== undefined) {
            updateBar("#water .bg", data.thirst);
        }

        if (data.action === "setValue") {
            handleSetValue(data.key, data.value, data.icon);
        } else if (data.action === "setTalking") {
            toggleTalking(data.value);
        } else if (data.action === "toggle") {
            toggleUI(data.show);
        }
    });
});

const updateBar = (selector, value) => {
    $(selector).css("width", `${value}%`);
};

const handleSetValue = (key, value, icon = null) => {
    if (key === "job" && icon) {
        setJobIcon(icon);
    }
    setValue(key, value);
};

const setValue = (key, value) => {
    $(`#${key} span`).html(value);
};

const setJobIcon = (icon) => {
    $('#job img').attr('src', `img/jobs/${icon}.png`);
};

const toggleTalking = (isTalking) => {
    const iconId = $('#id .iconid');
    if (isTalking) {
        iconId.css({
            border: "2px solid #ffffff",
            "border-radius": "100%",
        });
    } else {
        iconId.css({
            border: "none",
        });
    }
};

const toggleUI = (show) => {
    if (show) {
        $('#ui').fadeIn();
    } else {
        $('#ui').fadeOut();
    }
};