local isTalking = false
local postalsEnabled = RLO.showPLZ
local plzText = RLO.plzText
local playerID = 0
local hudVisible = false
local prox = 10.0
local drunk, thirst, hunger = 0, 0, 0
local nearestPostal, postalBlip = nil, nil
local hudStarted = false

RegisterNetEvent('esx:playerLoaded')
AddEventHandler('esx:playerLoaded', function(xPlayer)
    SetRloHud(xPlayer)
    hudStarted = true
end)

RegisterNetEvent('rlo_hud:restart')
AddEventHandler('rlo_hud:restart', function()
    local xPlayer = ESX.GetPlayerData()
    SetRloHud(xPlayer)
    hudStarted = true
end)

function SetRloHud(xPlayer)
    playerID = GetPlayerServerId(PlayerId())

    for _, account in pairs(xPlayer.accounts) do
        local key = account.name == "bank" and "bankmoney" or account.name == "black_money" and "dirtymoney"
        if key then
            SendNUIMessage({action = "setValue", key = key, value = "$" .. account.money})
        end
    end

    local idText = "ID " .. playerID .. (postalsEnabled and plzText or "")
    SendNUIMessage({action = "setValue", key = "id", value = idText})

    local job = xPlayer.job
    SendNUIMessage({action = "setValue", key = "job", value = job.grade_label, icon = job.name})
    SendNUIMessage({action = "setValue", key = "money", value = "$" .. xPlayer.money})
end

CreateThread(function()
    while true do
        Wait(100)
        local talking = NetworkIsPlayerTalking(PlayerId())
        if talking ~= isTalking then
            isTalking = talking
            SendNUIMessage({action = "setTalking", value = talking})
        end
    end
end)

local function toggleUI(state)
    hudVisible = state
    SendNUIMessage({action = "toggle", show = hudVisible})
end

RegisterNetEvent('ui:toggle')
AddEventHandler('ui:toggle', function()
    toggleUI(not hudVisible)
end)

RegisterNetEvent('ui:toggleon')
AddEventHandler('ui:toggleon', function()
    toggleUI(true)
end)

RegisterNetEvent('ui:toggleoff')
AddEventHandler('ui:toggleoff', function()
    toggleUI(false)
end)

local function updatePLZ()
    local idText = "ID " .. playerID .. (postalsEnabled and plzText or "")
    SendNUIMessage({action = "setValue", key = "id", value = idText})
end

RegisterNetEvent('ui:toggleplzon')
AddEventHandler('ui:toggleplzon', function()
    postalsEnabled = true
    updatePLZ()
end)

RegisterNetEvent('ui:toggleplzoff')
AddEventHandler('ui:toggleplzoff', function()
    postalsEnabled = false
    updatePLZ()
end)

RegisterNetEvent('esx:setAccountMoney')
AddEventHandler('esx:setAccountMoney', function(account)
    local key = account.name == "bank" and "bankmoney" or account.name == "black_money" and "dirtymoney" or account.name == "money" and "money"
    if key then
        SendNUIMessage({action = "setValue", key = key, value = "$" .. account.money})
    end
end)

RegisterNetEvent('esx:setJob')
AddEventHandler('esx:setJob', function(job)
    SendNUIMessage({action = "setValue", key = "job", value = job.grade_label, icon = job.name})
end)

AddEventHandler("esx_customui:updateStatus", function(basics)
    drunk, hunger, thirst = basics[1].percent, basics[2].percent, basics[3].percent
end)

CreateThread(function()
    while true do
        Wait(500)
        if hudStarted then
            SendNUIMessage({drunk = drunk, thirst = thirst, hunger = hunger})
            local inMenu = not IsPauseMenuActive()
            if hudVisible ~= inMenu then
                toggleUI(inMenu)
            end
        end
    end
end)

local rawPostals = LoadResourceFile(GetCurrentResourceName(), GetResourceMetadata(GetCurrentResourceName(), 'postal_file'))
local postals = json.decode(rawPostals)

CreateThread(function()
    while true do
        local playerCoords = GetEntityCoords(PlayerPedId())
        local nearestDistance = math.huge

        for i, postal in ipairs(postals) do
            local distance = #(vector2(playerCoords.x, playerCoords.y) - vector2(postal.x, postal.y))
            if distance < nearestDistance then
                nearestPostal = postal
                nearestDistance = distance
            end
        end
        Wait(200)
    end
end)

CreateThread(function()
    while true do
        if postalsEnabled and nearestPostal then
            local newPlzText = "   |   PLZ " .. nearestPostal.code
            if newPlzText ~= plzText then
                plzText = newPlzText
                updatePLZ()
            end
        end
        Wait(200)
    end
end)

CreateThread(function()
    while true do
        if postalBlip then
            local playerCoords = GetEntityCoords(PlayerPedId())
            local blipCoords = vector2(postalBlip.p.x, postalBlip.p.y)

            if #(vector2(playerCoords.x, playerCoords.y) - blipCoords) < RLO.blip.distToDelete then
                RemoveBlip(postalBlip.hndl)
                postalBlip = nil
            end
        end
        Wait(200)
    end
end)

RegisterCommand('p', function(_, args)
    if #args < 1 then
        if postalBlip then
            RemoveBlip(postalBlip.hndl)
            postalBlip = nil
        end
        return
    end

    local postalCode = string.upper(args[1])
    for _, postal in ipairs(postals) do
        if string.upper(postal.code) == postalCode then
            if postalBlip then RemoveBlip(postalBlip.hndl) end

            postalBlip = {
                hndl = AddBlipForCoord(postal.x, postal.y, 0.0),
                p = postal
            }
            SetBlipRoute(postalBlip.hndl, true)
            SetBlipColour(postalBlip.hndl, 3)
            SetBlipRouteColour(postalBlip.hndl, RLO.blip.color)
            BeginTextCommandSetBlipName('STRING')
            AddTextComponentSubstringPlayerName(RLO.blip.textFormat:format(postalBlip.p.code))
            EndTextCommandSetBlipName(postalBlip.hndl)

            ESX.ShowNotification('Zeichne Route zur PLZ: ~b~' .. postal.code)
            return
        end
    end

    ESX.ShowNotification('Diese PLZ existiert nicht.')
end)