ESX = nil
local notificationActive = false

-- ESX Initialisierung
CreateThread(function()
    while ESX == nil do
        TriggerEvent('esx:getSharedObject', function(obj) ESX = obj end)
        Wait(250)
    end
end)

-- Panikknopf
RegisterCommand('panicbutton', function()
    TriggerEvent('police_buttons:triggerPanic')
end, false)
RegisterKeyMapping('panicbutton', 'Panikknopf', 'keyboard', Config.Keys.Panic)

-- Positionsmeldung
RegisterCommand('positionbutton', function()
    TriggerEvent('police_buttons:triggerPosition')
end, false)
RegisterKeyMapping('positionbutton', 'Positionsmeldung', 'keyboard', Config.Keys.Position)

-- Panikknopf-Funktion
RegisterNetEvent('police_buttons:triggerPanic', function()
    if not IsAllowedJob() then
        ShowHelpNotification(Config.Messages.NoPermission)
        return
    end

    local coords = GetEntityCoords(PlayerPedId())
    TriggerServerEvent('police_buttons:sendNotification', coords, true)
end)

-- Positionsmeldung-Funktion
RegisterNetEvent('police_buttons:triggerPosition', function()
    if not IsAllowedJob() then
        ShowHelpNotification(Config.Messages.NoPermission)
        return
    end

    local coords = GetEntityCoords(PlayerPedId())
    TriggerServerEvent('police_buttons:sendNotification', coords, false)
end)

-- Empfangene Benachrichtigung
RegisterNetEvent('police_buttons:receiveNotification', function(message, coords, isPanic, senderName, senderId)
    local playerId = GetPlayerServerId(PlayerId())

    -- Zusätzliche Meldung über der Minimap mit Logo und Überschrift
    ShowAdvancedNotification("Police - System", 
        isPanic and "Notruf (Panik)" or "Positionsmeldung", 
        string.format("%s hat %s ausgelöst!", senderName, isPanic and "den Panikknopf" or "eine Positionsmeldung"), 
        "CHAR_CALL911", 
        1
    )

    -- Blip erstellen und für den Auslösenden sichtbar machen
    local blip = AddBlipForCoord(coords.x, coords.y, coords.z)
    SetBlipSprite(blip, 161)
    SetBlipScale(blip, 1.2)
    SetBlipColour(blip, isPanic and 1 or 3)
    BeginTextCommandSetBlipName("STRING")
    AddTextComponentString(isPanic and 'Panikknopf' or 'Position')
    EndTextCommandSetBlipName(blip)

    -- Blip nach 15 Sekunden entfernen
    CreateThread(function()
        Wait(15000)
        RemoveBlip(blip)
    end)

    -- Der Spieler, der die Meldung selbst ausgelöst hat, sieht keinen Annehmen-/Ablehnen-Dialog
    if playerId == senderId then
        return
    end

    notificationActive = true

    -- Annehmen/Ablehnen-Anzeige oben links
    ShowHelpNotification("Drücke ~INPUT_CONTEXT~ zum Annehmen oder ~INPUT_DETONATE~ zum Ablehnen.")

    local timeout = GetGameTimer() + Config.NotificationTimeout * 1000
    local accepted = false

    CreateThread(function()
        while GetGameTimer() < timeout do
            if IsControlJustPressed(0, 38) then -- E (Annehmen)
                accepted = true
                break
            elseif IsControlJustPressed(0, 47) then -- G (Ablehnen)
                break
            end
            Wait(0)
        end

        notificationActive = false

        if accepted then
            AcceptNotification(coords, isPanic)
        else
            ShowHelpNotification(Config.Messages.Declined)
        end
    end)
end)

-- Annahme der Benachrichtigung
function AcceptNotification(coords, isPanic)
    ShowHelpNotification(Config.Messages.Accepted)
    -- Setzt den Wegpunkt in der gleichen Farbe wie der Blip
    SetNewWaypoint(coords.x, coords.y)
end

-- Hilfsfunktionen
function IsAllowedJob()
    local playerData = ESX.GetPlayerData()
    for _, job in ipairs(Config.AllowedJobs) do
        if playerData.job and playerData.job.name == job then
            return true
        end
    end
    return false
end

function ShowHelpNotification(message)
    BeginTextCommandDisplayHelp("STRING")
    AddTextComponentSubstringPlayerName(message)
    EndTextCommandDisplayHelp(0, false, true, Config.NotificationTimeout * 1000)
end

function ShowAdvancedNotification(title, subtitle, message, icon, iconType)
    SetNotificationTextEntry("STRING")
    AddTextComponentSubstringPlayerName(message)
    SetNotificationMessage(icon, icon, true, iconType, title, subtitle)
    DrawNotification(false, true)
end
